*! version 5.0
* 13 August 2018
* NIDS
* Master Expenditure do file for Nids Wave 3

* THIS IS 5th EXPENDITURE DO FILE - POST-IMPUTATION AGGREGATION DO FILE: 5 OF 6
* THIS DO FILE AGGREGATES THE POST-IMPUTATION EXPENDITURE VARIABLES

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master Expenditure do file (1 of 6)"

version 12.1

*=====================================================================================================================================

/*NOTE: THIS DO FILE MUST BE RUN AFTER THE INCOME IMPUTATIONS HAVE BEEN RUN, AS
IT PULLS IN THE IMPLIED INCOME FROM OWNER-OCCUPIED HOUSING VARIABLE THAT
WAS CREATED IN THE INCOME IMPUTATION FILES.*/

use "$DataOUT\hhderived_INCOME.dta", clear
keep w3_hhid w3_hhimprent
rename w3_* *
rename hhid w3_hhid

merge 1:1 w3_hhid using "$DataOUT\imputed.dta"
drop _merge

egen expenditure=rowtotal(expf expnf rentexpend hhimprent)
replace expenditure=. if expenditure==0
replace expenditure=oneshotexp if expenditure==. & hhresponse==1

keep w3_hhid expf expnf rentexpend rentexpend_flg expenditure

save "$DataOUT\hhexp.dta", replace

* end of do file
*======================================================================================================================================
*check
